<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tree extends Model 
{

    protected $table = 'trees';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_ar', 'name_en', 'numeric_system', 'units');

    public function accounts()
    {
        return $this->hasMany('App\Models\Account');
    }

}